/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_DEMODULATE_H
#define HERMES2_DEMODULATE_H   1

#include "../common/transceiver.h"
#include <stdint.h>

//----------------------------------------------------------------------

// Noise Squelch parameters
#define SQUELCH_WINDOW_LENGTH   1000.0
#define SQUELCH_WINDOW_MULT  999.0   // above -1 always
#define SQUELCH_THRESHOLD    50
#define SQUELCH_RANGE        100

//----------------------------------------------------------------------

// Audio AGC reference Audio level
#define ADAGC_REF_LEVEL  30000.0

// Factors used in calculating ADAGC decay constant
#define ADAGC_DIVISOR  1000000.0

//----------------------------------------------------------------------

/* Sound PCSound Buffer has to be a ring
 * buffer to allow for the differences in the
 * SDR ADC and Sound card ADC sampling rates */
#define SOUND_OP_BUF_SIZE      2048
#define NUM_SOUND_RING_BUFFS  16
extern short  **sound_ring_buf;
extern uint32_t sound_ring_buf_idx;
extern uint32_t demod_ring_buf_idx;

//----------------------------------------------------------------------

/* demodulate.c */
void *Correct_Frequency_Offset(void *data);
void Alloc_Demod_Buf_Copies(uint32_t buf_len);
BOOLEAN Demodulate_FM(Transceiver_t *TRx, uint32_t sound_buf_len);
BOOLEAN Demodulate_AM(Transceiver_t *TRx, uint32_t sound_buf_len);
BOOLEAN Demodulate_SSB(Transceiver_t *TRx, uint32_t sound_buf_len);
BOOLEAN Demodulate_CW(Transceiver_t *TRx, uint32_t sound_buf_len);
void Free_Demod_Buffers(Transceiver_t *TRx);
void Free_Demod_Buf_Copies(void);

//----------------------------------------------------------------------

#endif

