/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_CALLBACKS_H
#define HERMES2_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

//----------------------------------------------------------------------

/* callbacks.c */
void on_hermes2_window_destroy(GObject *object, gpointer user_data);
gboolean on_hermes2_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_adc_addrx_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_quit_button_clicked(GtkButton *button, gpointer user_data);
gboolean on_tcvr_window_key_press(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_tcvr_window_enter_notify(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_tcvr_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_tcvr_window_destroy(GObject *object, gpointer user_data);
gboolean on_freq_scroll(GtkWidget *widget, const GdkEvent *event, gpointer user_data);
gboolean on_freq_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_to_tx_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_afc_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_rx_modes_menu_button_clicked(GtkButton *button, gpointer user_data);
void on_tx_modes_menu_button_clicked(GtkButton *button, gpointer user_data);
void on_guest_modes_menu_button_clicked(GtkButton *button, gpointer user_data);
void on_rx_bands_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_tx_bands_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_tx_power_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_mic_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_tx_pa_enable_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_mic_comp_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_mic_lpf_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_tune_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_mox_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_rx_weaver_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_tx_weaver_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_rx_bw_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_tx_bw_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_sample_rate_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_fft_bw_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_fft_rate_combobox_changed(GtkComboBox *combobox, gpointer user_data);
void on_volume_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_agc_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_squelch_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_squelch_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_adc_antenna1_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_adc_antenna2_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_tx_rx_duplex_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_lna_gain_auto_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_lna_gain_hw_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_lna_gain_value_changed(GtkSpinButton *spinbutton, gpointer user_data);
void on_hermes2_bmk_button_clicked(GtkButton *button, gpointer user_data);
void on_rx_start_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_hermes2_error_dialog_response(GtkDialog *dialog, gint response_id, gpointer user_data);
gboolean on_hermes2_error_dialog_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_hermes2_error_dialog_destroy(GObject *object, gpointer user_data);
void on_discovery_dialog_response(GtkDialog *dialog, gint response_id, gpointer user_data);
gboolean on_discovery_dialog_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_discovery_dialog_destroy(GObject *object, gpointer user_data);
void on_hermes2_message_dialog_response(GtkDialog *dialog, gint response_id, gpointer user_data);
void on_hermes2_message_dialog_destroy(GObject *object, gpointer user_data);
void on_hermes2_quit_dialog_response(GtkDialog *dialog, gint response_id, gpointer user_data);
void on_hermes2_quit_dialog_destroy(GObject *object, gpointer user_data);
gboolean on_hermes2_bmk_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_hermes2_bmk_window_destroy(GObject *object, gpointer user_data);
void on_hermes2_bmk_treeview_cursor_changed(GtkTreeView *treeview, gpointer user_data);
gboolean on_hermes2_bmk_treeview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_hermes2_bmk_treeview_row_expanded(GtkTreeView *tree_view, GtkTreeIter *iter, GtkTreePath *path, gpointer user_data);
void on_hermes2_bmk_down_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_bmk_up_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_bmk_delete_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_bmk_new_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_bmk_save_button_clicked(GtkButton *button, gpointer user_data);
void on_wideband_spectrum_radiobutton_toggled(GtkRadioButton *radiobutton, gpointer user_data);
void on_receiver_spectrum_radiobutton_toggled(GtkRadioButton *radiobutton, gpointer user_data);
gboolean on_hermes2_spectrum_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_hermes2_spectrum_drawingarea_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_hermes2_spectrum_drawingarea_realize(GtkWidget *widget, gpointer user_data);
void on_hermes2_spectrum_drawingarea_size_allocate(GtkWidget *widget, GdkRectangle *allocation, gpointer user_data);
void on_rx_modes_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_tx_modes_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_guest_modes_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_device_combobox_changed(GtkComboBox *combobox, gpointer user_data);
gboolean on_pointer_cross(GtkWidget *widget, const GdkEventButton *event, gpointer data);
void on_rx_zero_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_tx_zero_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_tx_freq_lock_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_hermes2_config_button_clicked(GtkButton *button, gpointer user_data);
void on_hermes2_config_dialog_response(GtkDialog *dialog, gint response_id, gpointer user_data);
gboolean on_hermes2_config_dialog_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_hermes2_config_dialog_destroy(GObject *object, gpointer user_data);
void on_mute_on_tx_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_guest_save_dialog_destroy(GObject *object, gpointer user_data);
void on_guest_cancel_save_clicked(GtkButton *button, gpointer user_data);
void on_guest_save_ok_clicked(GtkButton *button, gpointer user_data);
void on_tx_rsid_enable_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_rx_rsid_enable_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_rsid_apply_button_clicked(GtkButton *button, gpointer user_data);
gboolean on_rsid_apply_button_press_event(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_rsid_select_activate(GtkMenuItem *menuitem, gpointer user_data);

//----------------------------------------------------------------------

#endif

