/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_CALLBACK_FUNC_H
#define HERMES2_CALLBACK_FUNC_H   1

#include "../common/common.h"
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

// Signal modulation mode menu item names for Receiver
#define RX_MODE_MENU_ITEMS \
  _("USB-W"), \
  _("USB-M"), \
  _("USB-N"), \
  _("LSB-W"), \
  _("LSB-M"), \
  _("LSB-N"), \
  _("AM-W"), \
  _("AM-N"), \
  _("FMN-25K"), \
  _("FMN-12K"), \
  _("OLV 32/1000"), \
  _("OLV 16/1000"), \
  _("OLV 16/500"), \
  _("OLV 8/500"), \
  _("OLV 8/250"), \
  _("OLV 4/250"), \
  _("OLV 4/125"), \
  _("FTX"), \
  _("SSTV-U"), \
  _("SSTV-L"), \
  _("SAM-UW"), \
  _("SAM-UM"), \
  _("SAM-UN"), \
  _("SAM-LW"), \
  _("SAM-LM"), \
  _("SAM-LN"), \
  _("CWU-W"), \
  _("CWU-M"), \
  _("CWU-N"), \
  _("CWL-W"), \
  _("CWL-M"), \
  _("CWL-N"), \
  _("PSK31-U"), \
  _("PSK31-L"), \
  _("HELL-W"), \
  _("HELL-M"), \
  _("HELL-N"), \
  _("RTTY-W"), \
  _("RTTY-M"), \
  _("RTTY-N"), \
  _("RFAX-U"), \
  _("RFAX-L"), \
  _("WSPR"), \
  _("RSID")

//----------------------------------------------------------------------

// Signal modulation mode numbers for Receiver
enum RX_MOD_MODES
{
  RX_MODE_USBW = 0,
  RX_MODE_USBM,
  RX_MODE_USBN,
  RX_MODE_LSBW,
  RX_MODE_LSBM,
  RX_MODE_LSBN,
  RX_MODE_AMW,
  RX_MODE_AMN,
  RX_MODE_NBFM1,
  RX_MODE_NBFM2,
  RX_MODE_32_1000,
  RX_MODE_16_1000,
  RX_MODE_16_500,
  RX_MODE_8_500,
  RX_MODE_8_250,
  RX_MODE_4_250,
  RX_MODE_4_125,
  RX_MODE_FTX,
  RX_MODE_SSTVU,
  RX_MODE_SSTVL,
  RX_MODE_SAMUW,
  RX_MODE_SAMUM,
  RX_MODE_SAMUN,
  RX_MODE_SAMLW,
  RX_MODE_SAMLM,
  RX_MODE_SAMLN,
  RX_MODE_CWUW,
  RX_MODE_CWUM,
  RX_MODE_CWUN,
  RX_MODE_CWLW,
  RX_MODE_CWLM,
  RX_MODE_CWLN,
  RX_MODE_PSK31U,
  RX_MODE_PSK31L,
  RX_MODE_HELLW,
  RX_MODE_HELLM,
  RX_MODE_HELLN,
  RX_MODE_RTTYW,
  RX_MODE_RTTYM,
  RX_MODE_RTTYN,
  RX_MODE_RFAXU,
  RX_MODE_RFAXL,
  RX_MODE_WSPR,
  RX_MODE_RSID,
  RX_MODE_ITEMS
};

//----------------------------------------------------------------------

// Signal modulation mode menu item names for Transmitter
#define TX_MODE_MENU_ITEMS \
  _("USB-W"), \
  _("USB-M"), \
  _("USB-N"), \
  _("LSB-W"), \
  _("LSB-M"), \
  _("LSB-N"), \
  _("AM-W"), \
  _("AM-N"), \
  _("FMN-25K"), \
  _("FMN-12K"),\
  _("OLV 32/1000"), \
  _("OLV 16/1000"), \
  _("OLV 16/500"), \
  _("OLV 8/500"), \
  _("OLV 8/250"), \
  _("OLV 4/250"), \
  _("OLV 4/125"), \
  _("FTX"),\
  _("SSTV-U"), \
  _("SSTV-L"), \
  _("CW EXTERNAL"), \
  _("CW INTERNAL"), \
  _("GUEST"), \
  _("RX ONLY")

//----------------------------------------------------------------------

// Signal modulation mode numbers for Transmitter
enum TX_MOD_MODES
{
  TX_MODE_USBW = 0,
  TX_MODE_USBM,
  TX_MODE_USBN,
  TX_MODE_LSBW,
  TX_MODE_LSBM,
  TX_MODE_LSBN,
  TX_MODE_AMW,
  TX_MODE_AMN,
  TX_MODE_NBFM1,
  TX_MODE_NBFM2,
  TX_MODE_32_1000,
  TX_MODE_16_1000,
  TX_MODE_16_500,
  TX_MODE_8_500,
  TX_MODE_8_250,
  TX_MODE_4_250,
  TX_MODE_4_125,
  TX_MODE_FTX,
  TX_MODE_SSTVU,
  TX_MODE_SSTVL,
  TX_MODE_CW_EXTERN,
  TX_MODE_CW_INTERN,
  TX_MODE_GUEST,
  TX_MODE_RX_ONLY,
  TX_MODE_ITEMS
};

//----------------------------------------------------------------------

// Weaver frequencies for the Receiver
#define RX_WEAVER_FREQS \
  "BFO NONE",     "BFO 5.5 kHz",  "BFO 5.0 kHz", "BFO 4.8 kHz", \
  "BFO 4.6 kHz",  "BFO 4.4 kHz",  "BFO 4.2 kHz", "BFO 4.0 kHz", \
  "BFO 3.8 kHz",  "BFO 3.6 kHz",  "BFO 3.4 kHz", "BFO 3.2 kHz", \
  "BFO 3.0 kHz",  "BFO 2.8 kHz",  "BFO 2.6 kHz", "BFO 2.4 kHz", \
  "BFO 2.2 kHz",  "BFO 2.0 kHz",  "BFO 1.8 kHz", "BFO 1.6 kHz", \
  "BFO 1.4 kHz",  "BFO 1.2 kHz",  "BFO 1.0 kHz", "BFO 900 Hz",  \
  "BFO 800 Hz",   "BFO 750 Hz",   "BFO 700 Hz",  "BFO 625 Hz",  \
  "BFO 600 Hz",   "BFO 562.5 Hz", "BFO 500 Hz",  "BFO 250 Hz"

//----------------------------------------------------------------------

// Receiver Bandwidths
#define RX_BAND_WIDTHS \
  "B/W 50 kHz",  "B/W 25 kHz",  "B/W 12 kHz",  "B/W 8.0 kHz", \
  "B/W 5.0 kHz", "B/W 4.8 kHz", "B/W 4.5 kHz", "B/W 4.2 kHz", \
  "B/W 4.0 kHz", "B/W 3.8 kHz", "B/W 3.6 kHz", "B/W 3.4 kHz", \
  "B/W 3.2 kHz", "B/W 3.0 kHz", "B/W 2.8 kHz", "B/W 2.6 kHz", \
  "B/W 2.4 kHz", "B/W 2.2 kHz", "B/W 2.0 kHz", "B/W 1.8 kHz", \
  "B/W 1.6 kHz", "B/W 1.4 kHz", "B/W 1.2 kHz", "B/W 1.0 kHz", \
  "B/W 900 Hz",  "B/W 800 Hz",  "B/W 700 Hz",  "B/W 600 Hz", \
  "B/W 500 Hz",  "B/W 400 Hz",  "B/W 300 Hz",  "B/W 250 Hz", \
  "B/W 200 Hz",  "B/W 150 Hz",  "B/W 100 Hz"

//----------------------------------------------------------------------

// Weaver frequencies for the Transmitter
#define TX_WEAVER_FREQS \
  "CFO NONE",    "CFO 4.0 kHz", "CFO 3.7 kHz", "CFO 3.2 kHz", \
  "CFO 3.0 kHz", "CFO 2.8 kHz", "CFO 2.4 kHz", "CFO 2.0 kHz", \
  "CFO 1.5 kHz", "CFO 1250 Hz", "CFO 1125 Hz"

//----------------------------------------------------------------------

// Transmitter Bandwidths
#define TX_BAND_WIDTHS \
  "B/W 8.0 kHz", "B/W 6.5 kHz", "B/W 5.0 kHz", "B/W 3.8 kHz", \
  "B/W 3.6 kHz", "B/W 3.2 kHz", "B/W 3.0 kHz", "B/W 2.8 kHz", \
  "B/W 2.6 kHz", "B/W 2.4 kHz", "B/W 2.2 kHz", "B/W 2.0 kHz", \
  "B/W 1.2 kHz", "B/W 600 Hz",  "B/W 300 Hz",  "B/W 200 Hz"

//----------------------------------------------------------------------

/* Bandwidth settings for demodulator functions */
enum RX_BWIDTH
{
  RX_BW_50k,
  RX_BW_25k,
  RX_BW_12k,
  RX_BW_8k,
  RX_BW_5000,
  RX_BW_4800,
  RX_BW_4500,
  RX_BW_4200,
  RX_BW_4000,
  RX_BW_3800,
  RX_BW_3600,
  RX_BW_3400,
  RX_BW_3200,
  RX_BW_3000,
  RX_BW_2800,
  RX_BW_2600,
  RX_BW_2400,
  RX_BW_2200,
  RX_BW_2000,
  RX_BW_1800,
  RX_BW_1600,
  RX_BW_1400,
  RX_BW_1200,
  RX_BW_1000,
  RX_BW_900,
  RX_BW_800,
  RX_BW_700,
  RX_BW_600,
  RX_BW_500,
  RX_BW_400,
  RX_BW_300,
  RX_BW_250,
  RX_BW_200,
  RX_BW_150,
  RX_BW_100,
  RX_BANDWIDTH_NUM
};

//----------------------------------------------------------------------

/* Phasing frequencies for Weaver
 * method (SSB/CW) demodulators */
enum RX_WEAVER_FREQ
{
  RX_WEAVER_NONE = 0,
  RX_WEAVER_5500,
  RX_WEAVER_5000,
  RX_WEAVER_4800,
  RX_WEAVER_4600,
  RX_WEAVER_4400,
  RX_WEAVER_4200,
  RX_WEAVER_4000,
  RX_WEAVER_3800,
  RX_WEAVER_3600,
  RX_WEAVER_3400,
  RX_WEAVER_3200,
  RX_WEAVER_3000,
  RX_WEAVER_2800,
  RX_WEAVER_2600,
  RX_WEAVER_2400,
  RX_WEAVER_2200,
  RX_WEAVER_2000,
  RX_WEAVER_1800,
  RX_WEAVER_1600,
  RX_WEAVER_1400,
  RX_WEAVER_1200,
  RX_WEAVER_1000,
  RX_WEAVER_900,
  RX_WEAVER_800,
  RX_WEAVER_750,
  RX_WEAVER_700,
  RX_WEAVER_625,
  RX_WEAVER_600,
  RX_WEAVER_562,
  RX_WEAVER_500,
  RX_WEAVER_250,
  RX_WEAVER_FREQ_NUM
};

//----------------------------------------------------------------------

// Bandwidth settings for modulator functions
enum TX_BWIDTH
{
  TX_BW_8000 = 0,
  TX_BW_6500,
  TX_BW_5000,
  TX_BW_3800,
  TX_BW_3600,
  TX_BW_3200,
  TX_BW_3000,
  TX_BW_2800,
  TX_BW_2600,
  TX_BW_2400,
  TX_BW_2200,
  TX_BW_2000,
  TX_BW_1200,
  TX_BW_600,
  TX_BW_300,
  TX_BW_200,
  TX_BANDWIDTH_NUM
};

//----------------------------------------------------------------------

// Phasing frequencies for Weaver method (SSB/CW) modulators
enum TX_WEAVER_FREQ
{
  TX_WEAVER_NONE = 0,
  TX_WEAVER_4000,
  TX_WEAVER_3700,
  TX_WEAVER_3200,
  TX_WEAVER_3000,
  TX_WEAVER_2800,
  TX_WEAVER_2400,
  TX_WEAVER_2000,
  TX_WEAVER_1500,
  TX_WEAVER_1250,
  TX_WEAVER_1125,
  TX_WEAVER_FREQ_NUM
};

//----------------------------------------------------------------------

// Commands for Device_Start_Stop()
enum START_STOP_CMNDS
{
  START_RADIO_STREAM,
  STOP_RADIO_STREAM,
  START_SPEC_STREAM,
  STOP_SPEC_STREAM,
  START_BANDSCOPE,
  STOP_BANDSCOPE,
};

//----------------------------------------------------------------------

// Length of input buffers for Real FFT
#define REAL_FFT_INPUT_LENGTH   2048

/* callback_func.c */
void StartRx_Button_Toggled(gboolean active);
void Spectrum_Button_Toggled(gboolean active);
void ADC_Wideband_Toggled(gboolean active);
void PA_Enable_Button_Toggled(gboolean active);
void Tune_Button_Toggled(gboolean active);
void MOX_Button_Toggled(gboolean active);
void MOX_Control(BOOLEAN active);
void Quit_Dialog_Response(GtkDialog *dialog, gint response_id);
gboolean Time_Receive_Togglebutton_Toggled(gpointer togglebutton);
void Afc_Checkbutton_Toggled(uint8_t idx, gboolean active);
void Device_Combobox_Changed(GtkComboBox *combobox);
void Rx_Bands_Combobox_Changed(GtkComboBox *combobox);
void Tx_Bands_Combobox_Changed(GtkComboBox *combobox);
void Time_Station_Combobox_Changed(GtkComboBox *combobox);
void FFT_Bandwidth_Changed(GtkComboBox *combobox);
void Rx_Weaver_Combobox_Changed(GtkComboBox *combobox);
void Tx_Weaver_Combobox_Changed(GtkComboBox *combobox);
void Rx_Bandwidth_Combobox_Changed(GtkComboBox *combobox);
void Tx_Bandwidth_Combobox_Changed(GtkComboBox *combobox);
void Rate_Combobox_Changed(GtkComboBox *combobox);
void Modes_Menu_Item_Activate(GtkMenuItem *menuitem, BOOLEAN rx_flag);
void Guest_Modes_Menu_Item_Activate(GtkMenuItem *menuitem);
void Rx_Modulation_Mode_Changed(uint8_t trx_index, uint8_t mode);
void Tx_Modulation_Mode_Changed(uint8_t trx_index, uint8_t mode);
gboolean Frequency_Scroll_Event(GtkWidget *widget, const GdkEvent *event);
gboolean Frequency_Button_Press_Event(GtkWidget *widget, const GdkEventButton *event);
void Bookmarks_Button_Clicked(gpointer user_data);
void Pointer_Cross_Event(const GdkEventButton *event, gpointer data);
void Modes_Menu_Button_Clicked(BOOLEAN rx_flag);
void Guest_Modes_Menu_Button_Clicked(void);
void Rsid_Modes_Menu_Button_Clicked(void);
void FFT_Rate_Combobox_Changed(GtkComboBox *combobox);
void Squelch_Checkbutton_Toggled(gboolean active);
void RxID_Checkbutton_Toggled(gboolean active);
void Discovery_Dialog_Response(GtkDialog *dialog, gint response_id);

//----------------------------------------------------------------------

#endif

