/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_BOOKMARKS_H
#define HERMES2_BOOKMARKS_H   1

#include <gtk/gtk.h>

//----------------------------------------------------------------------

// Tree tree store and treeview for hermes2 bookmarks window
extern GtkTreeStore *hermes2_bmk_store;
extern GtkTreeView  *hermes2_bmk_treeview;

//----------------------------------------------------------------------

/* bookmarks.c */
void List_Bookmarks(void);
void Save_Bookmarks_File(void);
void Select_Treeview_Row(uint8_t direction);
void Bookmarks_Cursor_Changed(GtkTreeView *treeview);
gboolean Treeview_Button_Press(const GdkEventButton *event);
void New_Bookmarks_Row(void);
void Delete_Bookmarks_Row(void);

//----------------------------------------------------------------------

#endif

