/*
Keymap PS/2 to ASCII
Locale: en_US + CP866

the ps/2 e0-prefix for special keys (cursors etc) is
discarded in the reading-routine
*/

#include "scancodes.h"

const unsigned char keymap[] = {
	SC_A, 'a',
	SC_B, 'b',
	SC_C, 'c',
	SC_D, 'd',
	SC_E, 'e',
	SC_F, 'f',
	SC_G, 'g',
	SC_H, 'h',
	SC_I, 'i',
	SC_J, 'j',
	SC_K, 'k',
	SC_L, 'l',
	SC_M, 'm',
	SC_N, 'n',
	SC_O, 'o',
	SC_P, 'p',
	SC_Q, 'q',
	SC_R, 'r',
	SC_S, 's',
	SC_T, 't',
	SC_U, 'u',
	SC_V, 'v',
	SC_W, 'w',
	SC_X, 'x',
	SC_Y, 'y',
	SC_Z, 'z',

	SC_0, '0',
	SC_1, '1',
	SC_2, '2',
	SC_3, '3',
	SC_4, '4',
	SC_5, '5',
	SC_6, '6',
	SC_7, '7',
	SC_8, '8',
	SC_9, '9',

	SC_SPACE,		' ',
	SC_BKSPACE,		0x08,
	SC_COMMA,		',',
	SC_PERIOD,		'.',
	SC_SLASH,		'/',
	SC_SEMICOLON,		';',
	SC_DASH,		'-',
	SC_APOSTROPHE,		'\'',
	SC_EQUALS,		'=',
	SC_RETURN,		0x0d,
	SC_TAB,			0x18,
	SC_ESC,			0x1b,
	SC_SBRACKET_OP,		'[',
	SC_SBRACKET_CL,		']',
	SC_BACKSLASH,		'\\',
	SC_TILDA,		'`',
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_size = sizeof( keymap ) / 2;

const unsigned char keymap_shift[] = { 
	SC_A, 'A',
	SC_B, 'B',
	SC_C, 'C',
	SC_D, 'D',
	SC_E, 'E',
	SC_F, 'F',
	SC_G, 'G',
	SC_H, 'H',
	SC_I, 'I',
	SC_J, 'J',
	SC_K, 'K',
	SC_L, 'L',
	SC_M, 'M',
	SC_N, 'N',
	SC_O, 'O',
	SC_P, 'P',
	SC_Q, 'Q',
	SC_R, 'R',
	SC_S, 'S',
	SC_T, 'T',
	SC_U, 'U',
	SC_V, 'V',
	SC_W, 'W',
	SC_X, 'X',
	SC_Y, 'Y',
	SC_Z, 'Z',

	SC_1, '!',
	SC_2, '@',
	SC_3, '#',
	SC_4, '$',
	SC_5, '%',
	SC_6, '^',	
	SC_7, '&',
	SC_8, '*',
	SC_9, '(',
	SC_0, ')',

	SC_COMMA,		'<',
	SC_PERIOD,		'>',
	SC_SLASH,		'?',
	SC_SEMICOLON,		':',
	SC_APOSTROPHE,		'"',
	SC_EQUALS,		'+',
	SC_SBRACKET_OP,		'{',
	SC_SBRACKET_CL,		'}',
	SC_DASH,		'_',
	SC_BACKSLASH,		'|',
	SC_TILDA,		'~',
	SC_RETURN,		0x0a,
	SC_TAB,			0x09,
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_shift_size = sizeof( keymap_shift ) / 2;

const unsigned char keymap_caps[] = {
	SC_A, 'A',
	SC_B, 'B',
	SC_C, 'C',
	SC_D, 'D',
	SC_E, 'E',
	SC_F, 'F',
	SC_G, 'G',
	SC_H, 'H',
	SC_I, 'I',
	SC_J, 'J',
	SC_K, 'K',
	SC_L, 'L',
	SC_M, 'M',
	SC_N, 'N',
	SC_O, 'O',
	SC_P, 'P',
	SC_Q, 'Q',
	SC_R, 'R',
	SC_S, 'S',
	SC_T, 'T',
	SC_U, 'U',
	SC_V, 'V',
	SC_W, 'W',
	SC_X, 'X',
	SC_Y, 'Y',
	SC_Z, 'Z',

	SC_0, '0',
	SC_1, '1',
	SC_2, '2',
	SC_3, '3',
	SC_4, '4',
	SC_5, '5',
	SC_6, '6',
	SC_7, '7',
	SC_8, '8',
	SC_9, '9',

	SC_SPACE,		' ',
	SC_BKSPACE,		0x08,
	SC_COMMA,		',',
	SC_PERIOD,		'.',
	SC_SLASH,		'/',
	SC_SEMICOLON,		';',
	SC_DASH,		'-',
	SC_APOSTROPHE,		'\'',
	SC_EQUALS,		'=',
	SC_RETURN,		0x0d,
	SC_TAB,			0x18,
	SC_ESC,				0x1b,
	SC_SBRACKET_OP,		'[',
	SC_SBRACKET_CL,		']',
	SC_BACKSLASH,		'\\',
	SC_TILDA,		'`',
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_caps_size = sizeof( keymap_caps ) / 2;

const unsigned char keymap_caps_shift[] = {
	SC_A, 'a',
	SC_B, 'b',
	SC_C, 'c',
	SC_D, 'd',
	SC_E, 'e',
	SC_F, 'f',
	SC_G, 'g',
	SC_H, 'h',
	SC_I, 'i',
	SC_J, 'j',
	SC_K, 'k',
	SC_L, 'l',
	SC_M, 'm',
	SC_N, 'n',
	SC_O, 'o',
	SC_P, 'p',
	SC_Q, 'q',
	SC_R, 'r',
	SC_S, 's',
	SC_T, 't',
	SC_U, 'u',
	SC_V, 'v',
	SC_W, 'w',
	SC_X, 'x',
	SC_Y, 'y',
	SC_Z, 'z',

	SC_1, '!',
	SC_2, '@',
	SC_3, '#',
	SC_4, '$',
	SC_5, '%',
	SC_6, '^',	
	SC_7, '&',
	SC_8, '*',
	SC_9, '(',
	SC_0, ')',

	SC_COMMA,		'<',
	SC_PERIOD,		'>',
	SC_SLASH,		'?',
	SC_SEMICOLON,		':',
	SC_APOSTROPHE,		'"',
	SC_EQUALS,		'+',
	SC_SBRACKET_OP,		'{',
	SC_SBRACKET_CL,		'}',
	SC_DASH,		'_',
	SC_BACKSLASH,		'|',
	SC_TILDA,		'~',
	SC_RETURN,		0x0a,
	SC_TAB,			0x09,
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_caps_shift_size = sizeof( keymap_caps_shift ) / 2;

const unsigned char keymap_rus[] = {
	SC_A, 0xc6,
	SC_B, 0xc9,
	SC_C, 0xd3,
	SC_D, 0xd7,
	SC_E, 0xd5,
	SC_F, 0xc1,
	SC_G, 0xd0,
	SC_H, 0xd2,
	SC_I, 0xdb,
	SC_J, 0xcf,
	SC_K, 0xcc,
	SC_L, 0xc4,
	SC_M, 0xd8,
	SC_N, 0xd4,
	SC_O, 0xdd,
	SC_P, 0xda,
	SC_Q, 0xca,
	SC_R, 0xcb,
	SC_S, 0xd9,
	SC_T, 0xc5,
	SC_U, 0xc7,
	SC_V, 0xcd,
	SC_W, 0xc3,
	SC_X, 0xde,
	SC_Y, 0xce,
	SC_Z, 0xd1,

	SC_0, '0',
	SC_1, '1',
	SC_2, '2',
	SC_3, '3',
	SC_4, '4',
	SC_5, '5',
	SC_6, '6',
	SC_7, '7',
	SC_8, '8',
	SC_9, '9',

	SC_SPACE,		' ',
	SC_BKSPACE,		0x08,
	SC_COMMA,		0xc2,
	SC_PERIOD,		0xc0,
	SC_SLASH,		'.',
	SC_SEMICOLON,		0xd6,
	SC_DASH,		'-',
	SC_APOSTROPHE,		0xdc,
	SC_EQUALS,		'=',
	SC_RETURN,		0x0d,
	SC_TAB,			0x18,
	SC_ESC,			0x1b,
	SC_SBRACKET_OP,		0xc8,
	SC_SBRACKET_CL,		0xdf,
	SC_BACKSLASH,		'/',
	SC_TILDA,		0xc5,
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_rus_size = sizeof( keymap_rus ) / 2;

const unsigned char keymap_rus_shift[] = {
	SC_A, 0xe6,
	SC_B, 0xe9,
	SC_C, 0xf3,
	SC_D, 0xf7,
	SC_E, 0xf5,
	SC_F, 0xe1,
	SC_G, 0xf0,
	SC_H, 0xf2,
	SC_I, 0xfb,
	SC_J, 0xef,
	SC_K, 0xec,
	SC_L, 0xe4,
	SC_M, 0xf8,
	SC_N, 0xf4,
	SC_O, 0xfd,
	SC_P, 0xfa,
	SC_Q, 0xea,
	SC_R, 0xeb,
	SC_S, 0xf9,
	SC_T, 0xe5,
	SC_U, 0xe7,
	SC_V, 0xed,
	SC_W, 0xe3,
	SC_X, 0xfe,
	SC_Y, 0xee,
	SC_Z, 0xf1,

	SC_1, '!',
	SC_2, '"',
	SC_3, '#',
	SC_4, ';',
	SC_5, '%',
	SC_6, ':',	
	SC_7, '?',
	SC_8, '*',
	SC_9, '(',
	SC_0, ')',

	SC_COMMA,		0xe2,
	SC_PERIOD,		0xe0,
	SC_SLASH,		',',
	SC_SEMICOLON,		0xf6,
	SC_APOSTROPHE,		0xfc,
	SC_EQUALS,		'+',
	SC_DASH,		'_',
	SC_BACKSLASH,		'/',
	SC_SBRACKET_OP,		0xe8,
	SC_SBRACKET_CL,		0xff,
	SC_TILDA,		0xe5,
	SC_RETURN,		0x0a,
	SC_TAB,			0x09,
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};

const unsigned char keymap_rus_shift_size = sizeof( keymap_rus_shift ) / 2;

const unsigned char keymap_rus_caps[] = {
	SC_A, 0xe6,
	SC_B, 0xe9,
	SC_C, 0xf3,
	SC_D, 0xf7,
	SC_E, 0xf5,
	SC_F, 0xe1,
	SC_G, 0xf0,
	SC_H, 0xf2,
	SC_I, 0xfb,
	SC_J, 0xef,
	SC_K, 0xec,
	SC_L, 0xe4,
	SC_M, 0xf8,
	SC_N, 0xf4,
	SC_O, 0xfd,
	SC_P, 0xfa,
	SC_Q, 0xea,
	SC_R, 0xeb,
	SC_S, 0xf9,
	SC_T, 0xe5,
	SC_U, 0xe7,
	SC_V, 0xed,
	SC_W, 0xe3,
	SC_X, 0xfe,
	SC_Y, 0xee,
	SC_Z, 0xf1,

	SC_0, '0',
	SC_1, '1',
	SC_2, '2',
	SC_3, '3',
	SC_4, '4',
	SC_5, '5',
	SC_6, '6',
	SC_7, '7',
	SC_8, '8',
	SC_9, '9',

	SC_SPACE,		' ',
	SC_BKSPACE,		0x08,
	SC_COMMA,		0xe2,
	SC_PERIOD,		0xe0,
	SC_SLASH,		'.',
	SC_SEMICOLON,		0xf6,
	SC_APOSTROPHE,		0xfc,
	SC_DASH,		'-',
	SC_EQUALS,		'=',
	SC_RETURN,		0x0d,
	SC_TAB,			0x18,

	SC_ESC,			0x1b,
	SC_SBRACKET_OP,		0xe8,
	SC_SBRACKET_CL,		0xff,
	SC_TILDA,		0xe5,
	SC_BACKSLASH,		'/',
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_rus_caps_size = sizeof( keymap_rus_caps ) / 2;

const unsigned char keymap_rus_caps_shift[] = {
	SC_A, 0xc6,
	SC_B, 0xc9,
	SC_C, 0xd3,
	SC_D, 0xd7,
	SC_E, 0xd5,
	SC_F, 0xc1,
	SC_G, 0xd0,
	SC_H, 0xd2,
	SC_I, 0xdb,
	SC_J, 0xcf,
	SC_K, 0xcc,
	SC_L, 0xc4,
	SC_M, 0xd8,
	SC_N, 0xd4,
	SC_O, 0xdd,
	SC_P, 0xda,
	SC_Q, 0xca,
	SC_R, 0xcb,
	SC_S, 0xd9,
	SC_T, 0xc5,
	SC_U, 0xc7,
	SC_V, 0xcd,
	SC_W, 0xc3,
	SC_X, 0xde,
	SC_Y, 0xce,
	SC_Z, 0xd1,

	SC_1, '!',
	SC_2, '"',
	SC_3, '#',
	SC_4, ';',
	SC_5, '%',
	SC_6, ':',	
	SC_7, '?',
	SC_8, '*',
	SC_9, '(',
	SC_0, ')',

	SC_SPACE,		' ',
	SC_BKSPACE,		0x08,
	SC_COMMA,		0xc2,
	SC_PERIOD,		0xc0,
	SC_SLASH,		'.',
	SC_SEMICOLON,		0xd6,
	SC_DASH,		'-',
	SC_APOSTROPHE,		0xdc,
	SC_EQUALS,		'=',
	SC_RETURN,		0x0d,
	SC_TAB,			0x09,
	SC_ESC,			0x1b,
	SC_SBRACKET_OP,		0xc8,
	SC_SBRACKET_CL,		0xdf,
	SC_BACKSLASH,		'/',
	SC_TILDA,		0xc5,
	SC_RETURN,		0x0a,
	SC_TAB,			0x09,
 
	SC_CURSOR_LEFT,		0x1a,
	SC_CURSOR_RIGHT,	0x19,
	SC_CURSOR_DOWN,		0x1d,
	SC_CURSOR_UP,		0x1c,

	SC_F1,			0x81,
	SC_F2,			0x82,
	SC_F3,			0x83,
	SC_F4,			0x84,
	SC_F5,			0x85,
};
const unsigned char keymap_rus_caps_shift_size = sizeof( keymap_rus_caps_shift ) / 2;

const unsigned char keymap_ctrl[] = {
	SC_A, 0x01,
	SC_B, 0x02,
	SC_C, 0x03,
	SC_D, 0x04,
	SC_E, 0x05,
	SC_F, 0x06,
	SC_G, 0x07,
	SC_H, 0x08,
	SC_I, 0x09,
	SC_J, 0x0a,
	SC_K, 0x0b,
	SC_L, 0x0c,
	SC_M, 0x0d,
	SC_N, 0x0e,
	SC_O, 0x0f,
	SC_P, 0x10,
	SC_Q, 0x11,
	SC_R, 0x12,
	SC_S, 0x13,
	SC_T, 0x14,
	SC_U, 0x15,
	SC_V, 0x16,
	SC_W, 0x17,
	SC_X, 0x18,
	SC_Y, 0x19,
	SC_Z, 0x1a
};
const unsigned char keymap_ctrl_size = sizeof( keymap_ctrl ) / 2;

