
/*****************************************************************
 * This software is (c) by Paolo Cravero, IK1ZYW, ik1zyw@qsl.net *
 * See COPYING for license details.                              *
 * See README for operating instructions.                        *
 *                                                               *
 * Version: 1.2 , 19/November/2001                               *
 *****************************************************************/

#include <stdio.h>


long inband(long qrg) {

  /* Here you can add or customize frequency bands for which *
   * the software will check your XTALs                      */

  if ((qrg>=135000)&(qrg<=139000)) {
    return qrg;
  }
  if ((qrg>=1820000)&(qrg<=1850000)) {
    return qrg;
  }
  if ((qrg>=3500000)&(qrg<=3800000)) {
    return qrg;
  }
  if ((qrg>=7000000)&(qrg<=7100000)) {
    return qrg;
  }
  if ((qrg>=10100000)&(qrg<=10150000)) {
    return qrg;
  }
  if ((qrg>=14000000)&(qrg<=14350000)) {
    return qrg;
  }
  if ((qrg>=18068000)&(qrg<=18168000)) {
    return qrg;
  }
  if ((qrg>=21000000)&(qrg<=21450000)) {
    return qrg;
  }
  if ((qrg>=24890000)&(qrg<=24990000)) {
    return qrg;
  }
  if ((qrg>=28000000)&(qrg<=29500000)) {
    return qrg;
  }
  if ((qrg>=50000000)&(qrg<=51000000)) {
    return qrg;
  }
  if ((qrg>=144000000)&(qrg<=146000000)) {
    return qrg;
  }
  if ((qrg>=430000000)&(qrg<=438000000)) {
    return qrg;
  }

  return 0;
}


int comp (long quartz, long iff, unsigned int arm) {

  unsigned int i;
  long res;

  // check harmonics
  for (i=1;i<=arm;i++) {
    res=inband(i*quartz+iff);
    if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
    if (iff) {
      res=inband(i*quartz-iff);
      if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
    }
  }

  // check for sub-harmonics
  for (i=2;i<=arm;i=i+1) {
    res=inband(quartz/i+iff);
    if (res) {printf("It works on %d Hz, if divided by %d\n",res,i);}
  }

  return 0;

}


int checkmix (long quartz, long mixf, long iff, unsigned int arm) {

  long i;
  long res;

  // check harmonics
  for (i=1;i<=arm;i++) {

      res=inband((i*quartz)+mixf+iff);
      if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
      res=inband((i*quartz)-mixf+iff);
      if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
      if (iff) {
	res=inband((i*quartz)+mixf-iff);
	if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
	res=inband((i*quartz)-mixf-iff);
	if (res) {printf("It works on %d Hz, at %d harmonic\n",res,i);}
      }
  }

  // check for sub-harmonics
  for (i=2;i<=16;i=i*2) {

      res=inband((quartz/i)+mixf+iff);
      if (res) {printf("It works on %d Hz, if divided by %d\n",res,i);}
      res=inband(quartz/i-mixf+iff);
      if (res) {printf("It works on %d Hz, if divided by %d\n",res,i);}
      if (iff) {
	res=inband((quartz/i)+mixf-iff);
	if (res) {printf("It works on %d Hz, if divided by %d\n",res,i);}
	res=inband(quartz/i-mixf-iff);
	if (res) {printf("It works on %d Hz, if divided by %d\n",res,i);}
      }
  }

  return 0;

}

int main(int argc, char *argv[]) {

  unsigned int i;    // generic counter
  unsigned int arm=10;  // number of armonics 2 evaluate
  long mix=0;   // mixing check and frequency
  long quartz=1000000;
  long res=0;
  long ifv=0;

  if(argc<2) {
    printf("\nOUPS! Too few parameters!\n");
    printf("Please call\n%s -q<quartz_frequency_in_Hz> -a<harmonic_level> -m<mixing_freq> -i<IF_value>\n\n",argv[0]);
    return 1;
  }

  for (i=1;i<argc;i++) {
    if (strstr(argv[i],"-q")) {
      strcpy(argv[i],argv[i]+2);
      quartz = atoi(argv[i]);
      if ((int)quartz<=0) {
	printf("\nInvalid XTAL base frequency. Must be greater than 0!\n");
	return 1;
      }
    }
    if (strstr(argv[i],"-a")) {
      strcpy(argv[i],argv[i]+2);
      arm = atoi(argv[i]);
      if ((int)arm<=0) {
	printf("\nInvalid harmonic level. Must be greater than 0!\n");
	return 1;
      }
    }
    if (strstr(argv[i],"-m")) {
      strcpy(argv[i],argv[i]+2);
      mix = atoi(argv[i]);
      if ((int)mix<=0) {
	printf("\nInvalid mixing frequency. Must be greater than 0!\n");
	return 1;
      }
    }
    if (strstr(argv[i],"-i")) {
      strcpy(argv[i],argv[i]+2);
      ifv = atoi(argv[i]);
      if ((int)ifv<=0) {
	printf("\nInvalid IF frequency. Must be greater than 0!\n");
	return 1;
      }
    }
    
  }

  printf("\n              ik1zyw's XTAL utility\n\n");
  printf("------------------------------------------------------\n");
  printf("******* Checking %d Hz quartz *******\n",quartz);
  printf("\n>>> Results good for a TX or a direct-conversion RX <<<\n");
  i=comp(quartz,0,arm);

  printf("\n>>> Results good for an RX with 455kHz IF <<<\n");
  i=comp(quartz,455000,arm);

  printf("\n>>> Results good for an RX with 10.7MHz IF <<<\n");
  i=comp(quartz,10700000,arm);

  if (ifv>0) {
    printf("\n>>> Results good for an RX with %d Hz IF <<<\n",ifv);
    i=comp(quartz,ifv,arm);
  }

  // if the user wants to check mixing pissibilities
  if (mix>0) {
    printf("\n------------------------------------------------------");
    printf("\n******* Checking mixing with %d Hz *******\n",mix);

    printf("\n>>> Results good for a TX or a direct-conversion RX <<<\n");
    i=checkmix(quartz,mix,0,arm);

    printf("\n>>> Results good for an RX with 455kHz IF <<<\n");
    i=checkmix(quartz,mix,455000,arm);

    printf("\n>>> Results good for an RX with 10.7MHz IF <<<\n");
    i=checkmix(quartz,mix,10700000,arm);

    if (ifv>0) {
      printf("\n>>> Results good for an RX with %d Hz IF <<<\n",ifv);
      i=checkmix(quartz,mix,ifv,arm);
    }
  }

  printf("\nEnd of analysis. 73!\n\n");
}
